
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	


	[TestFixture]
	public class DAL_OrderedUnit : BaseTest 
	{

		private DataTable _dtOrderedUnit;
		private DataTable _dtBloodUnitStatus;

		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtOrderedUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit WHERE OrderedComponentGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				//Get BloodUnitStatus information for update
				this._dtBloodUnitStatus = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitStatus WHERE BloodUnitGuid = '" + this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.BloodUnitGuid].ToString() + "'", true);

				this.RefreshData = false;
			}
		}
		
		[Test]
		public void GetCurrentCrossmatchData_Pass()
		{	
			System.Guid ouGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.OrderedUnitGuid];

			DataRow drTest = DAL.OrderedUnit.GetCurrentCrossmatchData(ouGuid);

			Assert.IsTrue(true, "Any returned value is ok");

			// GetCurrentCrossmatchData will always return one row, each field containing nulls
			DataRow drNull = DAL.OrderedUnit.GetCurrentCrossmatchData(System.Guid.NewGuid());
			foreach(DataColumn dc in drNull.Table.Columns)
			{
				Assert.IsTrue(true == drNull.IsNull(dc.ColumnName));
			}
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetCurrentCrossmatchData_Fail()
		{	
			DAL.OrderedUnit.GetCurrentCrossmatchData(System.Guid.Empty);
		}


		[Test]
		public void GetOrderedUnitByGuid_Pass()
		{	
			System.Guid unitGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.OrderedUnitGuid];

			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitByGuid(unitGuid, UnitTestConfig.TestDivisionCode);
			
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.BloodUnitGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchRequiredIndicator));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchResultCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.DivisionCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.RecordStatusCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.LastUpdateDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.LastUpdateUser));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedTestGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedComponentGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.SelectedDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchTechId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.ReleaseDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.ReleaseTechId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.RowVersion));
		}

		[Test]
		public void GetOrderedUnitByGuid_Fail()
		{	
			DataTable dtTest = OrderedUnit.GetOrderedUnitByGuid(System.Guid.NewGuid(), UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetOrderedUnitByPatientAndUnit_Pass()
		{	
			System.Guid unitGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.BloodUnitGuid];
			System.Guid patientGuid = System.Guid.NewGuid();
			
			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitByPatientAndUnit(unitGuid.ToString(), patientGuid);
			
			Assert.AreEqual(19, dtTest.Columns.Count, "Columns.Count");
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchRequiredIndicator));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.SelectedDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.SelectedTechId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchResultCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchTechId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.RecordStatusCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedComponentGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.PatientTreatment.PatientLocation));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid));
            Assert.IsTrue(dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.CrossmatchResult.CrossmatchResultText));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.LastUpdateUser));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.RowVersion));
		}

		[Test]
		public void GetOrderedUnitByPatientAndUnit_Fail()
		{	
			//2899
			DataTable dtTest = OrderedUnit.GetOrderedUnitByPatientAndUnit(System.Guid.NewGuid().ToString(), System.Guid.NewGuid());
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetHistoricalOrderedUnits_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.BloodUnitGuid];

			DataTable dtTest = DAL.OrderedUnit.GetHistoricalOrderedUnits(unitGuid, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.BloodUnitGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchResultCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.DivisionCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.RecordStatusCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.LastUpdateDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.LastUpdateUser));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedTestGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedComponentGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.SelectedDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchTechId));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.ReleaseDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.OrderedUnit.RowVersion));
		}

		[Test]
		public void GetHistoricalOrderedUnits_Fail()
		{
			DataTable dtTest = OrderedUnit.GetHistoricalOrderedUnits(System.Guid.NewGuid(), UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetOrderedUnitByComponent_Pass()
		{	
			System.Guid unitGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.OrderedComponentGuid];
			
			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitByComponent(unitGuid, UnitTestConfig.TestDivisionCode);
			
			Assert.AreEqual(52, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		public void GetOrderedUnitByComponent_Fail()
		{	
			DataTable dtTest = OrderedUnit.GetOrderedUnitByComponent(System.Guid.NewGuid(), UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetOrderedUnitCount_Pass()
		{	
			System.Guid unitGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.OrderedComponentGuid];
			
			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitCount(unitGuid, UnitTestConfig.TestDivisionCode);
			
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		public void GetOrderedUnitCount_Fail()
		{	
			DataTable dtTest = OrderedUnit.GetOrderedUnitCount(System.Guid.NewGuid(), UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows[0][0].ToString() == "0");
		}

		[Test]
		public void GetOrderedUnitsForPatient_Pass()
		{	
			System.Guid patientGuid = System.Guid.NewGuid();
			
			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitsForPatient(patientGuid);
			
			Assert.AreEqual(48, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		public void GetOrderedUnitsForPatient_Fail()
		{	
			DataTable dtTest = OrderedUnit.GetOrderedUnitsForPatient(System.Guid.NewGuid());
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetOrderedUnitsForUnit_Pass()
		{	
			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitsForUnit();
			
			Assert.AreEqual(25, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderedUnitsForUnit_Fail()
		{	
		}

		[Test]
		public void GetOrderedUnitsForSpecimen_Pass()
		{	
			System.Guid specimenGuid = System.Guid.NewGuid();

			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitsForSpecimen(specimenGuid);
			
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetOrderedUnitsForSpecimen_Fail()
		{
			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitsForSpecimen(System.Guid.Empty);
		}

		
		[Test]
		public void GetOrderedUnits_Pass()
		{
			DataTable dtTest = OrderedUnit.GetOrderedUnits();
			Assert.AreEqual(38, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderedUnits_Fail()
		{
		}

		[Test]
		public void CheckIsAlreadyCrossMatched_Pass()
		{
			DataTable dtTest = OrderedUnit.GetOrderedUnits();
			Assert.AreEqual(38, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		public void CheckIsAlreadyCrossMatched_Fail()
		{
			DataTable dtTest = OrderedUnit.CheckIsAlreadyCrossMatched(System.Guid.NewGuid(), UnitTestConfig.TestDivisionCode, System.Guid.NewGuid());
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetOrderedUnit_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.BloodUnitGuid];

			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnit(unitGuid, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.BloodUnitGuid), TABLES.OrderedUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchRequiredIndicator), TABLES.OrderedUnit.CrossmatchRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchDate), TABLES.OrderedUnit.CrossmatchDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchResultCode), TABLES.OrderedUnit.CrossmatchResultCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.DivisionCode), TABLES.OrderedUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.RecordStatusCode), TABLES.OrderedUnit.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.LastUpdateDate), TABLES.OrderedUnit.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.LastUpdateUser), TABLES.OrderedUnit.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedTestGuid), TABLES.OrderedUnit.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedComponentGuid), TABLES.OrderedUnit.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid), TABLES.OrderedUnit.OrderedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.SelectedDate), TABLES.OrderedUnit.SelectedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchTechId), TABLES.OrderedUnit.CrossmatchTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.ReleaseDate), TABLES.OrderedUnit.ReleaseDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.ReleaseTechId), TABLES.OrderedUnit.ReleaseTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.RowVersion), TABLES.OrderedUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientGuid), TABLES.PatientSpecimen.PatientGuid);
		}

		[Test]
		public void GetOrderedUnit_Fail()
		{
			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnit(System.Guid.NewGuid(), UnitTestConfig.TestDivisionCode);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetOrderedUnitsForRepeatXM_Pass()
		{
			System.Guid testGuid = System.Guid.Empty;
			System.Guid componentGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.OrderedComponentGuid];

			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitsForRepeatXM(testGuid, componentGuid);

			Assert.AreEqual(21, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid), TABLES.OrderedUnit.OrderedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedComponentGuid), TABLES.OrderedUnit.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedTestGuid), TABLES.OrderedUnit.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.BloodUnitGuid), TABLES.OrderedUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchResultCode), TABLES.OrderedUnit.CrossmatchResultCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.RowVersion), TABLES.OrderedUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchRequiredIndicator), TABLES.OrderedUnit.CrossmatchRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.SelectedDate), TABLES.OrderedUnit.SelectedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.SelectedTechId), TABLES.OrderedUnit.SelectedTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);

		}

		[Test]
		public void GetOrderedUnitsForRepeatXM_Fail()
		{
			DataTable dtTest = DAL.OrderedUnit.GetOrderedUnitsForRepeatXM(Guid.NewGuid(), Guid.NewGuid());
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void IncompatibleCrossmatchResultsExist_Pass()
		{	
			string sSQL = " SELECT TOP 1 OU.BloodUnitGuid, P.PatientGuid" + 
							" FROM OrderedUnit OU " +
							" JOIN OrderedComponent OC 	ON OU.OrderedComponentGUID = OC.OrderedComponentGUID " +
							" JOIN PatientOrder PO	 	ON OC.PatientOrderGUID = PO.PatientOrderGUID " +
							" JOIN PatientTreatment PT 	ON PO.PatientTreatmentGuid = PT.PatientTreatmentGuid " +
							" JOIN Patient  P			ON P.PatientGUID =PT.PatientGUID " +
							" WHERE CrossmatchResultCode = 'D' OR CrossmatchResultCode = 'I'";

			DataTable dtData = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

			System.Guid patientGuid = (System.Guid)dtData.Rows[0][TABLES.PatientTreatment.PatientGuid];
			System.Guid unitGuid = (System.Guid)dtData.Rows[0][TABLES.OrderedUnit.BloodUnitGuid];

			bool retValue = DAL.OrderedUnit.IncompatibleCrossmatchResultsExist(patientGuid, unitGuid);

			Assert.AreEqual(true, retValue, "Returnvalue");
		}

		[Test]
		public void IncompatibleCrossmatchResultsExist_Fail()
		{	
			bool retValue = DAL.OrderedUnit.IncompatibleCrossmatchResultsExist(Guid.NewGuid(), Guid.NewGuid());
			Assert.AreEqual(false, retValue, "Returnvalue");
		}

		[Test]
		public void ReleaseOrderedUnits_2DTs_Pass()
		{
			this.RefreshData = true;

			System.Guid unitGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.OrderedUnitGuid];
			System.Guid bloodGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.BloodUnitGuid];
			System.Guid componentGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.OrderedComponentGuid];
			byte[] ouRowVersion = (byte[])this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.RowVersion];

			DataTable dtROrderedUnit = SprocHelper.GetReleaseOrderedUnitsSprocTable(unitGuid, ouRowVersion);
			DataTable dtIWorkload = SprocHelper.GetInsertWorkloadEventsSprocTable();
			
			dtIWorkload.Rows.Clear();

			bool retValue = DAL.OrderedUnit.ReleaseOrderedUnits(dtROrderedUnit, dtIWorkload, "Lohse did it", Common.UpdateFunction.UnitTests,null);

			if (retValue)
			{
				int uCheck = UnitTestUtil.RunSQL("UPDATE OrderedUnit SET ReleaseDate = NULL, ReleaseTechId = NULL WHERE BloodUnitGuid = '" + bloodGuid.ToString() + "'");
			}

			Assert.AreEqual(true, retValue, "Returnvalue");
		}

		[Test]
		public void ReleaseOrderedUnits_2DTs_Fail()
		{
			DataTable dtROrderedUnit = SprocHelper.GetReleaseOrderedUnitsSprocTable(System.Guid.NewGuid(), new byte[8]);
			DataTable dtIWorkload = SprocHelper.GetInsertWorkloadEventsSprocTable();
			
			try	//validate the Comment
			{
				DAL.OrderedUnit.ReleaseOrderedUnits(dtROrderedUnit, dtIWorkload, string.Empty, Common.UpdateFunction.UnitTests,null);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
			try	//Validate the Comment
			{
				DAL.OrderedUnit.ReleaseOrderedUnits(dtROrderedUnit, dtIWorkload, "".PadRight(511,'X'), Common.UpdateFunction.UnitTests,null);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
			try	//Validate the FunctionID
			{
				DAL.OrderedUnit.ReleaseOrderedUnits(dtROrderedUnit, dtIWorkload, "KABOOM", Common.UpdateFunction.Invalid,null);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

		}

		
		[Test]
		public void ReleaseOrderedUnits_DataTable_Pass()
		{
			this.RefreshData = true;

			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit WHERE ReleaseDate IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "'");
			
			System.Guid buGuid = (System.Guid)dtData.Rows[0][TABLES.OrderedUnit.BloodUnitGuid];
			byte[] ouRowVersion = (byte[])dtData.Rows[0][TABLES.OrderedUnit.RowVersion];

			DataTable dtTest = SprocHelper.GetReleaseOrderedUnitsByBloodUnitSprocTable(buGuid, ouRowVersion);

			bool retValue = DAL.OrderedUnit.ReleaseOrderedUnits(dtTest, Common.UpdateFunction.UnitTests,null);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void ReleaseOrderedUnits_DataTable_Fail()
		{
			this.RefreshData = true;

			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit WHERE ReleaseDate IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "'");

			DAL.OrderedUnit.ReleaseOrderedUnits(dtData, Common.UpdateFunction.Invalid,null);
		}
	}
}
#endif



